#
# Base settings for Django project {{ project_name }}. These settings are shared
# across all environments.
#
# Project created from template using Django {{ django_version }}.
#
# In order to specify environment-specific settings, use files:
#
# development.py
# testing.py
# staging.py
# production.py
#
# For more information on this file see
# https://docs.djangoproject.com/en/{{ docs_version }}/topics/settings/
#
# For the full list of settings and their values, see
# https://docs.djangoproject.com/en/{{ docs_version }}/ref/settings/


# Base paths for accessing project root directory and directory where assets are
# stored. Other paths can be built relative to these directories with:
# os.path.join(BASE_DIR, ...)
# os.path.join(ASSETS_DIR, ...)
import os

# Import the exception for signalling invalid configuration. No other
# Django-specific definitions should be imported here.
from django.core.exceptions import ImproperlyConfigured

# Base and assets project directories.
BASE_DIR = os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
ASSETS_ROOT = os.path.normpath(os.path.join(os.path.dirname(BASE_DIR), "assets"))

# List of installed applications.
INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
]

# List of middleware classes to apply to incoming requests.
MIDDLEWARE_CLASSES = (
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
)

# URL configuration to use for serving project root.
ROOT_URLCONF = '{{ project_name }}.urls'

# Template lookup and rendering configuration.
TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

# WSGI application module for running the project.
WSGI_APPLICATION = '{{ project_name }}.wsgi.application'


# Password validation
# https://docs.djangoproject.com/en/{{ docs_version }}/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Language, internationalisation, and time configuration.
#
# For details see
# https://docs.djangoproject.com/en/{{ docs_version }}/topics/i18n/
LANGUAGE_CODE = 'en-us'
TIME_ZONE = 'Europe/Stockholm'
USE_I18N = True
USE_L10N = True
USE_TZ = True

# URLs for serving the static and media files.
STATIC_URL = '/static/'
MEDIA_URL = '/media/'

# Directory for storing and serving user-uploaded files.
MEDIA_ROOT = os.path.normpath(os.path.join(ASSETS_ROOT, "media"))

# Directory for storing and serving static files.
STATIC_ROOT = os.path.normpath(os.path.join(ASSETS_ROOT, "static"))

# Additional directories from which to read the static files. This can be
# used for overriding application static files on project basis.
STATICFILES_DIRS = (
    os.path.normpath(os.path.join(BASE_DIR, '{{ project_name }}' , "static")),
)
