# Development environment settings for project {{ project_name }}.

# Import the base settings.
from .base import *

# Credentials in development environment are static.
SECRET_KEY="{{ secret_key }}"

# Enable debugging in development environment.
DEBUG = True
for template_config in TEMPLATES:
    template_config['OPTIONS']['debug']=True

# Site administrators and managers.
ADMINS = (
    # ('Your Name', 'your_email@example.com'),
)
MANAGERS = ADMINS

# Use SQLite3 for simplicity in development environment.
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': 'development.sqlite3',
        'USER': '',
        'PASSWORD': '',
        'HOST': '',
        'PORT': '',
    }
}

# Hostnames/FQDNs considered valid for accessing the installation.
ALLOWED_HOSTS = []

# Disable password validation in development.
AUTH_PASSWORD_VALIDATORS = []
