# Testing environment settings for project {{ project_name }}.

# Import the base settings.
from .base import *

# Import credentials.
try:
    from .credentials import DATABASE_PASSWORD
except ImportError:
    raise ImproperlyConfigured("Please configure DATABASE_PASSWORD in credentials.py.")

try:
    from .credentials import SECRET_KEY
except ImportError:
    raise ImproperlyConfigured("Please configure SECRET_KEY in credentials.py.")

# Disable debugging.
DEBUG = False
for template_config in TEMPLATES:
    template_config['OPTIONS']['debug']=False

# Site administrators and managers.
ADMINS = (
    # ('Your Name', 'your_email@example.com'),
)
MANAGERS = ADMINS

# Database configuration.
DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',
        'NAME': '{{ project_name }}',
        'USER': '{{ project_name }}',
        'PASSWORD': DATABASE_PASSWORD,
        'HOST': '127.0.0.1',
        'PORT': '',
    }
}

# Hostnames/FQDNs considered valid for accessing the installation.
ALLOWED_HOSTS = []
